/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.animation;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.api.client.IModifiableProgress;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.Keyframes;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.event.FlowDirection;
import lib.toma.animations.api.event.IAnimationDirectionProvider;
import lib.toma.animations.api.event.IAnimationEvent;
import net.minecraft.client.renderer.IRenderTypeBuffer;

public class StagedReloadAnimation
implements IModifiableProgress,
IAnimationDirectionProvider {
    private final BooleanSupplier finished;
    private final Supplier<Float> progressFetcher;
    private final Map<AnimationStage, IKeyframe[]> frameCache;
    private final IAnimationEvent[] events;
    private float progress;
    private float progressOld;
    private float progressInterpolated;
    private FlowDirection direction = FlowDirection.FORWARD;

    public StagedReloadAnimation(IKeyframeProvider provider, BooleanSupplier finished, Supplier<Float> progressFetcher) {
        this.frameCache = provider.getFrameMap();
        this.finished = finished;
        this.progressFetcher = progressFetcher;
        this.events = provider.getEvents();
    }

    @Override
    public FlowDirection getDirection() {
        return this.direction;
    }

    @Override
    public void gameTick() {
        this.progressOld = this.progress;
        this.progress = this.getProgress();
        this.direction = this.progress > this.progressOld ? FlowDirection.FORWARD : (this.progress < this.progressOld ? FlowDirection.BACKWARD : this.direction);
    }

    @Override
    public void renderTick(float deltaRenderTime) {
        float old = this.progressInterpolated;
        this.progressInterpolated = AnimationUtils.linearInterpolate(this.progress, this.progressOld, deltaRenderTime);
        AnimationUtils.dispatchEventsMultiFlow(this.progressInterpolated, old, this, this.events);
    }

    @Override
    public void animate(AnimationStage stage, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer, int light, int overlay) {
        float prevProgress;
        IKeyframe[] frames = this.frameCache.get(stage);
        if (frames == null) {
            return;
        }
        int frameIndex = this.getFrameIndex(frames);
        IKeyframe frame = this.getKeyframe(frameIndex, frames);
        IKeyframe old = this.getKeyframe(frameIndex - 1, frames);
        float actualProgress = frame.endpoint();
        float min = actualProgress - (prevProgress = old.endpoint());
        float progress = min == 0.0f ? 1.0f : (this.progressInterpolated - prevProgress) / (actualProgress - prevProgress);
        Keyframes.processFrame(frame, progress, matrixStack);
    }

    @Override
    public boolean hasFinished() {
        return this.finished.getAsBoolean();
    }

    @Override
    public float getProgress() {
        return this.progressFetcher.get().floatValue();
    }

    private int getFrameIndex(IKeyframe[] frames) {
        boolean inverse;
        boolean bl = inverse = (double)this.progressInterpolated > 0.5;
        if (inverse) {
            for (int i = frames.length - 2; i >= 0; --i) {
                IKeyframe keyframe = frames[i];
                if (!(keyframe.endpoint() <= this.progressInterpolated)) continue;
                return i + 1;
            }
        } else {
            IKeyframe last = frames[0];
            for (int i = 1; i < frames.length; ++i) {
                IKeyframe keyframe = frames[i];
                if (last.endpoint() <= this.progressInterpolated && keyframe.endpoint() > this.progressInterpolated) {
                    return i;
                }
                last = keyframe;
            }
        }
        return -1;
    }

    private IKeyframe getKeyframe(int index, IKeyframe[] frames) {
        return index < 0 ? Keyframes.none() : frames[index];
    }
}

